/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.modifiers.StatModifier;

public class SpawnerCategory
implements IRecipeCategory<SpawnerModifier> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/spawner_jei.png");
    public static final ResourceLocation UID = new ResourceLocation("apotheosis", "spawner_modifiers");
    public static final RecipeType<SpawnerModifier> TYPE = RecipeType.create((String)"apotheosis", (String)"spawner_modifiers", SpawnerModifier.class);
    private IDrawable bg;
    private IDrawable icon;
    private Component title;

    public SpawnerCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(TEXTURES, 0, 0, 169, 75).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42007_));
        this.title = new TranslatableComponent("title.apotheosis.spawner");
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public RecipeType<SpawnerModifier> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawnerModifier recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 11).addIngredients(recipe.getMainhandInput());
        if (recipe.getOffhandInput() != Ingredient.f_43901_) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 48).addIngredients(recipe.getOffhandInput());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Blocks.f_50085_));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Blocks.f_50085_));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends SpawnerModifier> getRecipeClass() {
        return SpawnerModifier.class;
    }

    /*
     * Unable to fully structure code
     */
    public void draw(SpawnerModifier recipe, PoseStack stack, double mouseX, double mouseY) {
        if (recipe.getOffhandInput() == Ingredient.f_43901_) {
            GuiComponent.m_93143_((PoseStack)stack, (int)1, (int)31, (int)0, (float)0.0f, (float)88.0f, (int)28, (int)34, (int)256, (int)256);
        }
        if ((scn = Minecraft.m_91087_().f_91080_) == null) {
            return;
        }
        if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 13.0 && mouseY < 25.0) {
            GuiComponent.m_93143_((PoseStack)stack, (int)-1, (int)13, (int)0, (float)0.0f, (float)75.0f, (int)10, (int)12, (int)256, (int)256);
            scn.m_96597_(stack, Arrays.asList(new Component[]{new TranslatableComponent("misc.apotheosis.mainhand")}), (int)mouseX, (int)mouseY);
        } else if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 50.0 && mouseY < 62.0 && recipe.getOffhandInput() != Ingredient.f_43901_) {
            GuiComponent.m_93143_((PoseStack)stack, (int)-1, (int)50, (int)0, (float)0.0f, (float)75.0f, (int)10, (int)12, (int)256, (int)256);
            scn.m_96597_(stack, Arrays.asList(new Component[]{new TranslatableComponent("misc.apotheosis.offhand"), new TranslatableComponent("misc.apotheosis.not_consumed").m_130940_(ChatFormatting.GRAY)}), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 33.0 && mouseX < 49.0 && mouseY >= 30.0 && mouseY < 46.0) {
            scn.m_96597_(stack, Arrays.asList(new Component[]{new TranslatableComponent("misc.apotheosis.rclick_spawner")}), (int)mouseX, (int)mouseY);
        }
        mvStack = RenderSystem.m_157191_();
        mvStack.m_85836_();
        mvMatrix = mvStack.m_85850_().m_85861_();
        mvMatrix.m_27624_();
        mvMatrix.m_27644_(stack.m_85850_().m_85861_());
        mvStack.m_85837_(0.0, 0.5, -2000.0);
        Minecraft.m_91087_().m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42007_), 31, 29);
        mvStack.m_85849_();
        RenderSystem.m_157182_();
        font = Minecraft.m_91087_().f_91062_;
        v0 = recipe.getStatModifiers().size();
        Objects.requireNonNull(font);
        top = 37 - v0 * (9 + 2) / 2 + 2;
        left = 168;
        for (StatModifier<?> s : recipe.getStatModifiers()) {
            value = s.value.toString();
            if (value.equals("true")) {
                value = "+";
            } else if (value.equals("false")) {
                value = "-";
            } else {
                var17_16 = s.value;
                if (var17_16 instanceof Number && (num = (Number)var17_16).intValue() > 0) {
                    value = "+" + (String)value;
                }
            }
            msg = new TranslatableComponent("misc.apotheosis.concat", new Object[]{value, s.stat.name()});
            width = font.m_92852_((FormattedText)msg);
            if (!(mouseX >= (double)(left - width)) || !(mouseX < (double)left) || !(mouseY >= (double)top)) ** GOTO lbl-1000
            Objects.requireNonNull(font);
            if (mouseY < (double)(top + 9 + 1)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            hover = v1;
            font.m_92889_(stack, (Component)msg, (float)(left - font.m_92852_((FormattedText)msg)), (float)top, hover != false ? 0x8080FF : 0x333333);
            maxWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            maxWidth = maxWidth - (maxWidth - 210) / 2 - 210;
            if (hover) {
                list = new ArrayList<Component>();
                list.add((Component)s.stat.name().m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}));
                list.add((Component)s.stat.desc().m_130940_(ChatFormatting.GRAY));
                if (s.value instanceof Number) {
                    if (((Number)s.min).intValue() > 0 || ((Number)s.max).intValue() != 0x7FFFFFFF) {
                        list.add((Component)new TextComponent(" "));
                    }
                    if (((Number)s.min).intValue() > 0) {
                        list.add((Component)new TranslatableComponent("misc.apotheosis.min_value", new Object[]{s.min}).m_130940_(ChatFormatting.GRAY));
                    }
                    if (((Number)s.max).intValue() != 0x7FFFFFFF) {
                        list.add((Component)new TranslatableComponent("misc.apotheosis.max_value", new Object[]{s.max}).m_130940_(ChatFormatting.GRAY));
                    }
                }
                SpawnerCategory.renderComponentTooltip(scn, stack, list, left + 6, (int)mouseY, maxWidth, font);
            }
            Objects.requireNonNull(font);
            top += 9 + 2;
        }
    }

    private static void renderComponentTooltip(Screen scn, PoseStack stack, List<Component> list, int x, int y, int maxWidth, Font font) {
        List text = list.stream().map(c -> font.m_92865_().m_92414_((FormattedText)c, maxWidth, c.m_7383_())).flatMap(Collection::stream).toList();
        scn.renderComponentTooltip(stack, text, x, y, font);
    }
}

